<?php
require_once("../config/session.php");
require_once("../config/connection.php");

// Verify user is logged in
confirm_logged_in();

// Check if the form is submitted
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Verify CSRF token
    if (!csrf_verify($_POST['csrf_token'] ?? null)) {
        http_response_code(403);
        die('Invalid CSRF token');
    }

    // Sanitize and validate inputs
    $id = get_int('id');
    $menu_name = get_str('menu_name');
    $menu_icon = get_str('menu_icon');
    $menu_type = get_str('menu_type');
    $menu_data = get_str('menu_data');
    $toolbar_color = get_str('toolbar_color');
    $is_enabled = get_bool('is_enabled') ? 1 : 0;

    // Validate required fields
    if ($id <= 0 || empty($menu_name) || empty($menu_type)) {
        header('Location: ../pages/list_pages.php?error=missing_fields');
        exit();
    }

    // Validate menu type
    $allowed_types = ['webview', 'wordpress', 'intent', 'custom', 'rss', 'ytrss'];
    if (!in_array($menu_type, $allowed_types)) {
        header('Location: ../pages/list_pages.php?error=invalid_type');
        exit();
    }

    // Update the menu item data in the database
    $query = "UPDATE app_menu SET menu_name=?, menu_icon=?, menu_type=?, menu_data=?, is_enabled=?, toolbar_color=? WHERE id=?";
    
    $stmt = $mysqli->prepare($query);
    if ($stmt === false) {
        error_log('MySQL prepare error: ' . $mysqli->error);
        header('Location: ../pages/list_pages.php?error=database_error');
        exit();
    }
    
    $stmt->bind_param("ssssisi", $menu_name, $menu_icon, $menu_type, $menu_data, $is_enabled, $toolbar_color, $id);
    
    if ($stmt->execute()) {
        $stmt->close();
        header('Location: ../pages/list_pages.php?success=1');
        exit();
    } else {
        error_log("Error updating menu item ID $id: " . $stmt->error);
        $stmt->close();
        header('Location: ../pages/list_pages.php?error=update_failed');
        exit();
    }
} else {
    http_response_code(405);
    die('Method not allowed');
}
?>
